/*
 * Decompiled with CFR 0.152.
 */
package com.android.payment.domain.model;

import com.android.payment.domain.model.ACheckDto;
import com.android.payment.domain.model.SettlementDto;
import com.utility.ConvertStr;
import java.util.List;

public class SettlementDto {
    private long id;
    private long serverId;
    private String date;
    private String actionDate;
    private int afoType;
    private double cash;
    private String cashHeading;
    private double pos;
    private double totalPayment;
    private int state;
    private String posHeading;
    private String customerCode;
    private String description;
    private boolean payment;
    private String bankCode;
    private Double sumCheck;
    private long userCode;
    private List<ACheckDto> checkDtoList;
    private Double discount;
    private String customerHeading;

    public Integer getAction() {
        return this.getPos() > 0.0 ? 1 : 0;
    }

    public double getSumCheck() {
        if (this.sumCheck != null) {
            return this.sumCheck;
        }
        this.sumCheck = ConvertStr.sumOf((Iterable)this.getCheckDtoList(), ACheckDto::getAmount);
        return this.sumCheck;
    }

    SettlementDto(long id, long serverId, String date, String actionDate, int afoType, double cash, String cashHeading, double pos, double totalPayment, int state, String posHeading, String customerCode, String description, boolean payment, String bankCode, Double sumCheck, long userCode, List<ACheckDto> checkDtoList, Double discount, String customerHeading) {
        this.id = id;
        this.serverId = serverId;
        this.date = date;
        this.actionDate = actionDate;
        this.afoType = afoType;
        this.cash = cash;
        this.cashHeading = cashHeading;
        this.pos = pos;
        this.totalPayment = totalPayment;
        this.state = state;
        this.posHeading = posHeading;
        this.customerCode = customerCode;
        this.description = description;
        this.payment = payment;
        this.bankCode = bankCode;
        this.sumCheck = sumCheck;
        this.userCode = userCode;
        this.checkDtoList = checkDtoList;
        this.discount = discount;
        this.customerHeading = customerHeading;
    }

    public static SettlementDtoBuilder builder() {
        return new SettlementDtoBuilder();
    }

    public long getId() {
        return this.id;
    }

    public long getServerId() {
        return this.serverId;
    }

    public String getDate() {
        return this.date;
    }

    public String getActionDate() {
        return this.actionDate;
    }

    public int getAfoType() {
        return this.afoType;
    }

    public double getCash() {
        return this.cash;
    }

    public String getCashHeading() {
        return this.cashHeading;
    }

    public double getPos() {
        return this.pos;
    }

    public double getTotalPayment() {
        return this.totalPayment;
    }

    public int getState() {
        return this.state;
    }

    public String getPosHeading() {
        return this.posHeading;
    }

    public String getCustomerCode() {
        return this.customerCode;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isPayment() {
        return this.payment;
    }

    public String getBankCode() {
        return this.bankCode;
    }

    public long getUserCode() {
        return this.userCode;
    }

    public List<ACheckDto> getCheckDtoList() {
        return this.checkDtoList;
    }

    public Double getDiscount() {
        return this.discount;
    }

    public String getCustomerHeading() {
        return this.customerHeading;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setServerId(long serverId) {
        this.serverId = serverId;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void setActionDate(String actionDate) {
        this.actionDate = actionDate;
    }

    public void setAfoType(int afoType) {
        this.afoType = afoType;
    }

    public void setCash(double cash) {
        this.cash = cash;
    }

    public void setCashHeading(String cashHeading) {
        this.cashHeading = cashHeading;
    }

    public void setPos(double pos) {
        this.pos = pos;
    }

    public void setTotalPayment(double totalPayment) {
        this.totalPayment = totalPayment;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void setPosHeading(String posHeading) {
        this.posHeading = posHeading;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setPayment(boolean payment) {
        this.payment = payment;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public void setSumCheck(Double sumCheck) {
        this.sumCheck = sumCheck;
    }

    public void setUserCode(long userCode) {
        this.userCode = userCode;
    }

    public void setCheckDtoList(List<ACheckDto> checkDtoList) {
        this.checkDtoList = checkDtoList;
    }

    public void setDiscount(Double discount) {
        this.discount = discount;
    }

    public void setCustomerHeading(String customerHeading) {
        this.customerHeading = customerHeading;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SettlementDto)) {
            return false;
        }
        SettlementDto other = (SettlementDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getServerId() != other.getServerId()) {
            return false;
        }
        if (this.getAfoType() != other.getAfoType()) {
            return false;
        }
        if (Double.compare(this.getCash(), other.getCash()) != 0) {
            return false;
        }
        if (Double.compare(this.getPos(), other.getPos()) != 0) {
            return false;
        }
        if (Double.compare(this.getTotalPayment(), other.getTotalPayment()) != 0) {
            return false;
        }
        if (this.getState() != other.getState()) {
            return false;
        }
        if (this.isPayment() != other.isPayment()) {
            return false;
        }
        if (this.getUserCode() != other.getUserCode()) {
            return false;
        }
        if (Double.compare(this.getSumCheck(), other.getSumCheck()) != 0) {
            return false;
        }
        Double this$discount = this.getDiscount();
        Double other$discount = other.getDiscount();
        if (this$discount == null ? other$discount != null : !((Object)this$discount).equals(other$discount)) {
            return false;
        }
        String this$date = this.getDate();
        String other$date = other.getDate();
        if (this$date == null ? other$date != null : !this$date.equals(other$date)) {
            return false;
        }
        String this$actionDate = this.getActionDate();
        String other$actionDate = other.getActionDate();
        if (this$actionDate == null ? other$actionDate != null : !this$actionDate.equals(other$actionDate)) {
            return false;
        }
        String this$cashHeading = this.getCashHeading();
        String other$cashHeading = other.getCashHeading();
        if (this$cashHeading == null ? other$cashHeading != null : !this$cashHeading.equals(other$cashHeading)) {
            return false;
        }
        String this$posHeading = this.getPosHeading();
        String other$posHeading = other.getPosHeading();
        if (this$posHeading == null ? other$posHeading != null : !this$posHeading.equals(other$posHeading)) {
            return false;
        }
        String this$customerCode = this.getCustomerCode();
        String other$customerCode = other.getCustomerCode();
        if (this$customerCode == null ? other$customerCode != null : !this$customerCode.equals(other$customerCode)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$bankCode = this.getBankCode();
        String other$bankCode = other.getBankCode();
        if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) {
            return false;
        }
        List this$checkDtoList = this.getCheckDtoList();
        List other$checkDtoList = other.getCheckDtoList();
        if (this$checkDtoList == null ? other$checkDtoList != null : !((Object)this$checkDtoList).equals(other$checkDtoList)) {
            return false;
        }
        String this$customerHeading = this.getCustomerHeading();
        String other$customerHeading = other.getCustomerHeading();
        return !(this$customerHeading == null ? other$customerHeading != null : !this$customerHeading.equals(other$customerHeading));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SettlementDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        long $serverId = this.getServerId();
        result = result * 59 + (int)($serverId >>> 32 ^ $serverId);
        result = result * 59 + this.getAfoType();
        long $cash = Double.doubleToLongBits(this.getCash());
        result = result * 59 + (int)($cash >>> 32 ^ $cash);
        long $pos = Double.doubleToLongBits(this.getPos());
        result = result * 59 + (int)($pos >>> 32 ^ $pos);
        long $totalPayment = Double.doubleToLongBits(this.getTotalPayment());
        result = result * 59 + (int)($totalPayment >>> 32 ^ $totalPayment);
        result = result * 59 + this.getState();
        result = result * 59 + (this.isPayment() ? 79 : 97);
        long $userCode = this.getUserCode();
        result = result * 59 + (int)($userCode >>> 32 ^ $userCode);
        long $sumCheck = Double.doubleToLongBits(this.getSumCheck());
        result = result * 59 + (int)($sumCheck >>> 32 ^ $sumCheck);
        Double $discount = this.getDiscount();
        result = result * 59 + ($discount == null ? 43 : ((Object)$discount).hashCode());
        String $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : $date.hashCode());
        String $actionDate = this.getActionDate();
        result = result * 59 + ($actionDate == null ? 43 : $actionDate.hashCode());
        String $cashHeading = this.getCashHeading();
        result = result * 59 + ($cashHeading == null ? 43 : $cashHeading.hashCode());
        String $posHeading = this.getPosHeading();
        result = result * 59 + ($posHeading == null ? 43 : $posHeading.hashCode());
        String $customerCode = this.getCustomerCode();
        result = result * 59 + ($customerCode == null ? 43 : $customerCode.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $bankCode = this.getBankCode();
        result = result * 59 + ($bankCode == null ? 43 : $bankCode.hashCode());
        List $checkDtoList = this.getCheckDtoList();
        result = result * 59 + ($checkDtoList == null ? 43 : ((Object)$checkDtoList).hashCode());
        String $customerHeading = this.getCustomerHeading();
        result = result * 59 + ($customerHeading == null ? 43 : $customerHeading.hashCode());
        return result;
    }

    public String toString() {
        return "SettlementDto(id=" + this.getId() + ", serverId=" + this.getServerId() + ", date=" + this.getDate() + ", actionDate=" + this.getActionDate() + ", afoType=" + this.getAfoType() + ", cash=" + this.getCash() + ", cashHeading=" + this.getCashHeading() + ", pos=" + this.getPos() + ", totalPayment=" + this.getTotalPayment() + ", state=" + this.getState() + ", posHeading=" + this.getPosHeading() + ", customerCode=" + this.getCustomerCode() + ", description=" + this.getDescription() + ", payment=" + this.isPayment() + ", bankCode=" + this.getBankCode() + ", sumCheck=" + this.getSumCheck() + ", userCode=" + this.getUserCode() + ", checkDtoList=" + this.getCheckDtoList() + ", discount=" + this.getDiscount() + ", customerHeading=" + this.getCustomerHeading() + ")";
    }
}

